<?php
/**
 * The template 'Style 5' to displaying related posts
 *
 * @package JACQUELINE
 * @since JACQUELINE 1.0.54
 */

$jacqueline_link        = get_permalink();
$jacqueline_post_format = get_post_format();
$jacqueline_post_format = empty( $jacqueline_post_format ) ? 'standard' : str_replace( 'post-format-', '', $jacqueline_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $jacqueline_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	jacqueline_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'jacqueline_filter_related_thumb_size', jacqueline_get_thumb_size( (int) jacqueline_get_theme_option( 'related_posts' ) == 1 ? 'big' : 'med' ) ),
		)
	);
	?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $jacqueline_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( '- No title -', 'jacqueline' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			?>
			<div class="post_meta">
				<a href="<?php echo esc_url( $jacqueline_link ); ?>" class="post_meta_item post_date"><?php echo wp_kses_data( jacqueline_get_date() ); ?></a>
			</div>
			<?php
		}
		?>
	</div>
</div>
