<?php
/* Yith Woocommerce Gift Cards
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'jacqueline_yith_woocommerce_gift_cards_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'jacqueline_yith_woocommerce_gift_cards_theme_setup9', 9 );
    function jacqueline_yith_woocommerce_gift_cards_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'jacqueline_filter_tgmpa_required_plugins', 'jacqueline_yith_woocommerce_gift_cards_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'jacqueline_yith_woocommerce_gift_cards_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('jacqueline_filter_tgmpa_required_plugins',	'jacqueline_yith_woocommerce_gift_cards_tgmpa_required_plugins');
    function jacqueline_yith_woocommerce_gift_cards_tgmpa_required_plugins( $list = array() ) {
        if ( jacqueline_storage_isset( 'required_plugins', 'yith-woocommerce-gift-cards' ) && jacqueline_storage_get_array( 'required_plugins', 'yith-woocommerce-gift-cards', 'install' ) !== false ) {
            // Bookly Responsive Appointment Booking Tool Plugin
            $list[] = array(
                'name'     => jacqueline_storage_get_array( 'required_plugins', 'yith-woocommerce-gift-cards', 'title' ),
                'slug'     => 'yith-woocommerce-gift-cards',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if Yith Woocommerce Gift Cards Plugin installed and activated
if ( ! function_exists( 'jacqueline_exists_yith_woocommerce_gift_cards' ) ) {
    function jacqueline_exists_yith_woocommerce_gift_cards() {
        return  function_exists( 'yith_ywgc_init' );
    }
}
