<?php
/* Bookly Responsive Appointment Booking Tool
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'jacqueline_bookly_responsive_appointment_booking_tool_theme_setup9', 9 );
    function jacqueline_bookly_responsive_appointment_booking_tool_theme_setup9() {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() ) {
            add_action( 'wp_enqueue_scripts', 'jacqueline_bookly_responsive_appointment_booking_tool_frontend_scripts', 1100 );
            add_filter( 'jacqueline_filter_merge_styles', 'jacqueline_bookly_responsive_appointment_booking_tool_merge_styles' );
        }
        if ( is_admin() ) {
            add_filter( 'jacqueline_filter_tgmpa_required_plugins', 'jacqueline_bookly_responsive_appointment_booking_tool_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('jacqueline_filter_tgmpa_required_plugins',	'jacqueline_bookly_responsive_appointment_booking_tool_tgmpa_required_plugins');
    function jacqueline_bookly_responsive_appointment_booking_tool_tgmpa_required_plugins( $list = array() ) {
        if ( jacqueline_storage_isset( 'required_plugins', 'bookly-responsive-appointment-booking-tool' ) && jacqueline_storage_get_array( 'required_plugins', 'bookly-responsive-appointment-booking-tool', 'install' ) !== false ) {
            // Bookly Responsive Appointment Booking Tool Plugin
            $list[] = array(
                'name'     => jacqueline_storage_get_array( 'required_plugins', 'bookly-responsive-appointment-booking-tool', 'title' ),
                'slug'     => 'bookly-responsive-appointment-booking-tool',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if Bookly Responsive Appointment Booking Tool Plugin installed and activated
if ( ! function_exists( 'jacqueline_exists_bookly_responsive_appointment_booking_tool' ) ) {
    function jacqueline_exists_bookly_responsive_appointment_booking_tool() {
        return function_exists('bookly_loader');
    }
}

// One-click import support
//------------------------------------------------------------------------

// Check plugin in the required plugins
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_required_plugins' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_required_plugins',	'jacqueline_bookly_responsive_appointment_booking_tool_importer_required_plugins', 10, 2 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_required_plugins($not_installed='', $list='') {
        if (strpos($list, 'bookly-responsive-appointment-booking-tool')!==false && !jacqueline_exists_bookly_responsive_appointment_booking_tool() )
            $not_installed .= '<br>' . esc_html__('Bookly Appointment', 'jacqueline');
        return $not_installed;
    }
}

// Set plugin's specific importer options
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_set_options' ) ) {
    add_filter( 'trx_addons_filter_importer_options',	'jacqueline_bookly_responsive_appointment_booking_tool_importer_set_options' );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_set_options($options=array()) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $options['required_plugins']) ) {
            $options['additional_options'][] = 'bookly_%';
            if (is_array($options['files']) && count($options['files']) > 0) {
                foreach ($options['files'] as $k => $v) {
                    $options['files'][$k]['file_with_bookly-responsive-appointment-booking-tool'] = str_replace('name.ext', 'bookly-responsive-appointment-booking-tool.txt', $v['file_with_']);
                }
            }
        }
        return $options;
    }
}

// Prevent import plugin's specific options if plugin is not installed
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_check_options' ) ) {
    add_filter( 'trx_addons_filter_import_theme_options', 'jacqueline_bookly_responsive_appointment_booking_tool_importer_check_options', 10, 4 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_check_options($allow, $k, $v, $options) {
        if ($allow && (strpos($k, 'bookly_')===0) ) {
            $allow = jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $options['required_plugins']);
        }
        return $allow;
    }
}

// Add checkbox to the one-click importer
if ( !function_exists( 'trx_addons_bookly_responsive_appointment_booking_tool_importer_show_params' ) ) {
    add_action( 'trx_addons_action_importer_params',	'trx_addons_bookly_responsive_appointment_booking_tool_importer_show_params', 10, 1 );
    function trx_addons_bookly_responsive_appointment_booking_tool_importer_show_params($importer) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $importer->options['required_plugins']) ) {
            $importer->show_importer_params(array(
                'slug' => 'bookly-responsive-appointment-booking-tool',
                'title' => esc_html__('Import Bookly Appointment', 'jacqueline'),
                'part' => 0
            ));
        }
    }
}

// Import posts
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_import' ) ) {
    add_action( 'trx_addons_action_importer_import', 'jacqueline_bookly_responsive_appointment_booking_tool_importer_import', 10, 2 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_import($importer, $action) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $importer->options['required_plugins']) ) {
            if ( $action == 'import_bookly-responsive-appointment-booking-tool' ) {
                $importer->response['start_from_id'] = 0;
                $importer->import_dump('bookly-responsive-appointment-booking-tool', esc_html__('Bookly Appointment meta', 'jacqueline'));
            }
        }
    }
}

// Display import progress
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_import_fields' ) ) {
    add_action( 'trx_addons_action_importer_import_fields',	'jacqueline_bookly_responsive_appointment_booking_tool_importer_import_fields', 10, 1 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_import_fields($importer) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $importer->options['required_plugins']) ) {
            $importer->show_importer_fields(array(
                    'slug'=>'bookly-responsive-appointment-booking-tool',
                    'title' => esc_html__('Bookly Appointment meta', 'jacqueline')
                )
            );
        }
    }
}

// Export posts
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_export' ) ) {
    add_action( 'trx_addons_action_importer_export',	'jacqueline_bookly_responsive_appointment_booking_tool_importer_export', 10, 1 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_export($importer) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $importer->options['required_plugins']) ) {
            trx_addons_fpc($importer->export_file_dir('bookly-responsive-appointment-booking-tool.txt'), serialize( array(
                    "bookly_appointments"			          	=> $importer->export_dump("bookly_appointments"),
                    "bookly_categories"	                        => $importer->export_dump("bookly_categories"),
                    "bookly_customers"					        => $importer->export_dump("bookly_customers"),
                    "bookly_customer_appointments"				=> $importer->export_dump("bookly_customer_appointments"),
                    "bookly_holidays"						    => $importer->export_dump("bookly_holidays"),
                    "bookly_log"						        => $importer->export_dump("bookly_log"),
                    "bookly_messages"						    => $importer->export_dump("bookly_messages"),
                    "bookly_notifications"						=> $importer->export_dump("bookly_notifications"),
                    "bookly_payments"						    => $importer->export_dump("bookly_payments"),
                    "bookly_schedule_item_breaks"				=> $importer->export_dump("bookly_schedule_item_breaks"),
                    "bookly_sent_notifications"					=> $importer->export_dump("bookly_sent_notifications"),
                    "bookly_series"						        => $importer->export_dump("bookly_series"),
                    "bookly_services"						    => $importer->export_dump("bookly_services"),
                    "bookly_shop"					  	        => $importer->export_dump("bookly_shop"),
                    "bookly_staff"						        => $importer->export_dump("bookly_staff"),
                    "bookly_staff_schedule_items"				=> $importer->export_dump("bookly_staff_schedule_items"),
                    "bookly_staff_services"						=> $importer->export_dump("bookly_staff_services"),
                    "bookly_stats"						        => $importer->export_dump("bookly_stats"),
                    "bookly_sub_services"						=> $importer->export_dump("bookly_sub_services")
                ) )
            );
        }
    }
}

// Display exported data in the fields
if ( !function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_importer_export_fields' ) ) {
    add_action( 'trx_addons_action_importer_export_fields',	'jacqueline_bookly_responsive_appointment_booking_tool_importer_export_fields', 10, 1 );
    function jacqueline_bookly_responsive_appointment_booking_tool_importer_export_fields($importer) {
        if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() && in_array('bookly-responsive-appointment-booking-tool', $importer->options['required_plugins']) ) {
            $importer->show_exporter_fields(array(
                    'slug'	=> 'bookly-responsive-appointment-booking-tool',
                    'title' => esc_html__('Bookly Appointment', 'jacqueline')
                )
            );
        }
    }
}


// Enqueue custom scripts
if ( ! function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_frontend_scripts' ) ) {
    //Handler of the add_action( 'wp_enqueue_scripts', 'jacqueline_bookly_responsive_appointment_booking_tool_frontend_scripts', 1100 );
    function jacqueline_bookly_responsive_appointment_booking_tool_frontend_scripts() {
        if ( jacqueline_is_on( jacqueline_get_theme_option( 'debug_mode' ) ) ) {
            $jacqueline_url = jacqueline_get_file_url( 'plugins/bookly-responsive-appointment-booking-tool/bookly-responsive-appointment-booking-tool.css' );
            if ( '' != $jacqueline_url ) {
                wp_enqueue_style( 'jacqueline-bookly-responsive-appointment-booking-tool', $jacqueline_url, array(), null );
            }
        }
    }
}

// Merge custom styles
if ( ! function_exists( 'jacqueline_bookly_responsive_appointment_booking_tool_merge_styles' ) ) {
    //Handler of the add_filter('jacqueline_filter_merge_styles', 'jacqueline_bookly_responsive_appointment_booking_tool_merge_styles');
    function jacqueline_bookly_responsive_appointment_booking_tool_merge_styles( $list ) {
        $list[] = 'plugins/bookly-responsive-appointment-booking-tool/bookly-responsive-appointment-booking-tool.css';
        return $list;
    }
}

// Add plugin-specific colors and fonts to the custom CSS
if ( jacqueline_exists_bookly_responsive_appointment_booking_tool() ) {
    require_once jacqueline_get_file_dir( 'plugins/bookly-responsive-appointment-booking-tool/bookly-responsive-appointment-booking-tool-style.php' );
}
