<?php

namespace ThemeRex\OpenAi;

class Url {
    public const ORIGIN = 'https://api.openai.com';
    public const SITE = 'https://beta.openai.com';
    public const API_VERSION = 'v1';

    /**
     * @return string
     */
    public static function baseURL( $endpoint = '', $type = 'api' ): string {
		return ( $type == 'api' ? self::ORIGIN . "/" . self::API_VERSION : self::SITE ) . ( ! empty( $endpoint ) ? "/{$endpoint}" : '' );
    }

    /**
     * @deprecated
     * @param string $engine
     * @return string
     */
    public static function completionURL(string $engine): string {
        return self::baseURL( "engines/$engine/completions" );
    }

    /**
     * @return string
     */
    public static function completionsURL(): string {
        return self::baseURL( "completions" );
    }

    /**
     *
     * @return string
     */
    public static function editsUrl(): string {
        return self::baseURL( "edits" );
    }

    /**
     * @param string $engine
     * @return string
     */
    public static function searchURL(string $engine): string {
        return self::baseURL( "engines/$engine/search" );
    }

    /**
     * @param
     * @return string
     */
    public static function enginesUrl(): string {
        return self::baseURL( "engines" );
    }

    /**
     * @param string $engine
     * @return string
     */
    public static function engineUrl(string $engine): string {
        return self::baseURL( "engines/$engine" );
    }

    /**
     * @param
     * @return string
     */
    public static function classificationsUrl(): string {
        return self::baseURL( "classifications" );
    }

    /**
     * @param
     * @return string
     */
    public static function moderationUrl(): string {
        return self::baseURL( "moderations" );
    }

    /**
     * @param
     * @return string
     */
    public static function speechUrl(): string {
        return self::baseURL( "/audio/speech" );
    }

    /**
     * @param
     * @return string
     */
    public static function transcriptionsUrl(): string {
        return self::baseURL( "audio/transcriptions" );
    }

    /**
     * @param
     * @return string
     */
    public static function translationsUrl(): string {
        return self::baseURL( "audio/translations" );
    }

    /**
     * @param
     * @return string
     */
    public static function filesUrl(): string {
        return self::baseURL( "files" );
    }

    /**
     * @param
     * @return string
     */
    public static function fineTuneUrl(): string {
        return self::baseURL( "fine-tunes" );
    }

    /**
     * @param
     * @return string
     */
    public static function fineTuneModel(): string {
        return self::baseURL( "models" );
    }

    /**
     * @param
     * @return string
     */
    public static function answersUrl(): string {
        return self::baseURL( "answers" );
    }

    /**
     * @param
     * @return string
     */
    public static function imageUrl(): string {
        return self::baseURL( "images" );
    }

    /**
     * @param
     * @return string
     */
    public static function embeddings(): string {
        return self::baseURL( "embeddings" );
    }

    /**
     * @param
     * @return string
     */
    public static function chatUrl(): string {
        return self::baseURL( "chat/completions" );
    }
}
